﻿#pragma once

namespace RTCam {

class Texture1D;
class Texture;

class Lens
{
public:
	Lens();
	~Lens();

	// The focal length rating for the current lens
	// (how strongly it converges light)
	float GetFocalLength();
	void SetFocalLength(float focalLength);
	float ValidateFocalLength(float focalLength);

	// The current lens distance (from the film)
	float GetLensDistance();
	void SetLensDistance(float lensDistance);
	float ValidateLensDistance(float lensDistance);

	// The current focal distance (from the lens)
	float GetFocalDistance();
	void SetFocalDistance(float focalDistance);
	float ValidateFocalDistance(float focalDistance);

	// Calculate the focal distance when the lens is at a specific distance from the film, and vice versa
	static float CalcFocalDistance(float focalLength, float lensDistance);
	static float CalcLensDistance(float focalLength, float focalDistance);

	void SetFocalRanges(float minFocalLength, float maxFocalLength, float minFocalDistance);

	shared_ptr<Texture1D> m_distortionTex;
	shared_ptr<Texture1D> m_sagittalTex;
	shared_ptr<Texture1D> m_tangentialTex;

	struct Vignetting {
		float fNumber;
		shared_ptr<Texture1D> vignettingTex;
	};
	vector<Vignetting> m_vignettingTexs;

	float m_sphericalAberrationFactor;

	// Spherical aberration textures
	shared_ptr<Texture> m_positiveSATex;
	shared_ptr<Texture> m_zeroSATex;
	shared_ptr<Texture> m_negativeSATex;

private:
	float m_lensFocalLength;	// The focal length rating for the current lens
	float m_minFocalLength;
	float m_maxFocalLength;
	
	float m_minFocalDistance;

	float m_curLensDistance;	// The current distance between the lens and the film
};


}